#pragma once

#include <mail/notsolitesrv/src/mdbsave/iclient.h>
#include <mail/notsolitesrv/src/meta_save_op/types/request.h>
#include <mail/notsolitesrv/src/meta_save_op/types/response.h>
#include <mail/notsolitesrv/src/rules_applier/types/response.h>
#include <mail/notsolitesrv/src/types/common.h>

#include <boost/optional.hpp>

#include <cstdint>
#include <map>
#include <optional>
#include <string>
#include <vector>

namespace NNotSoLiteSrv::NMetaSaveOp {

std::map<TDeliveryId, std::string> MakeFailureStatusByDeliveryIdMap(
    const std::optional<NRulesApplier::TRulesApplierResponse>& rulesApplierResponse,
    const NMdbSave::TMdbSaveResult& mdbSave);

EStatus MakeRecipientResponseStatus(const std::string& status);

boost::optional<std::vector<TAutoReply>> MakeRecipientResponseReply(
    const std::vector<NRulesApplier::TAutoreply>& replies);

boost::optional<std::vector<TForward>> MakeRecipientResponseForward(
    const std::vector<std::string>& forwards);

boost::optional<std::vector<TNotify>> MakeRecipientResponseNotify(
    const std::vector<std::string>& notifies);

uint32_t MakeMdbCommitResponseImapId(const std::optional<std::string>& imapId);

boost::optional<NMetaSaveOp::TResolvedFolder> MakeResolvedFolder(
    const std::optional<NMdbSave::TResolvedFolder>& folder);

TResolvedLabel MakeResolvedLabel(const NMdbSave::TResponseLabel& label);

boost::optional<std::vector<TResolvedLabel>> MakeResolvedLabels(
    const std::optional<std::vector<NMdbSave::TResponseLabel>>& labels);

boost::optional<TMdbCommitResponse> MakeMdbCommitResponse(const TDeliveryId& deliveryId,
    const NMdbSave::TMdbSaveResult& mdbSave);

TRecipientResponse MakeRecipientResponse(
    const std::map<TDeliveryId, std::string>& failureStatusByDeliveryId,
    const TDeliveryId& deliveryId,
    bool useFilters,
    const std::optional<NRulesApplier::TRulesApplierResponse>& rulesApplierResponse,
    const NMdbSave::TMdbSaveResult& mdbSave);

TResponse::TMdbResponses MakeMdbResponses(
    const TRecipientMap& recipients,
    const std::optional<NRulesApplier::TRulesApplierResponse>& rulesApplierResponse,
    const NMdbSave::TMdbSaveResult& mdbSave);

TResponse MakeResponse(
    const TRecipientMap& recipients,
    const std::optional<NRulesApplier::TRulesApplierResponse>& rulesApplierResponse,
    const NMdbSave::TMdbSaveResult& mdbSave);

}
