#include "rules_applier.h"

#include "common.h"

#include <mail/notsolitesrv/src/util/optional.h>

#include <algorithm>
#include <iterator>
#include <utility>

namespace NNotSoLiteSrv::NMetaSaveOp {

using NUtil::ConvertOptional;

NRulesApplier::TMessage MakeRulesApplierMessage(const NMetaSaveOp::TMessage& message) {
    NRulesApplier::TMessage rulesApplierMessage;
    if (!message.from.empty()) {
        rulesApplierMessage.From = message.from.front();
    }

    rulesApplierMessage.Sender = ConvertOptional(message.sender);
    rulesApplierMessage.ReplyTo = ConvertOptional(message.reply_to);

    return rulesApplierMessage;
}

NRulesApplier::TRecipient MakeRulesApplierRecipient(const NMetaSaveOp::TRecipient& recipient) {
    return {recipient.user.uid, recipient.params.use_filters};
}

NRulesApplier::TRecipientMap MakeRulesApplierRecipientMap(const NMetaSaveOp::TRecipientMap& recipients) {
    NRulesApplier::TRecipientMap rulesApplierRecipients;
    auto transformer = [](const auto& element) {
        return std::make_pair(element.first, MakeRulesApplierRecipient(element.second));
    };

    std::transform(recipients.cbegin(), recipients.cend(), std::inserter(rulesApplierRecipients,
        rulesApplierRecipients.end()), std::move(transformer));
    return rulesApplierRecipients;
}

NRulesApplier::TRulesApplierRequest MakeRulesApplierRequest(const TRequest& request) {
    NRulesApplier::TRulesApplierRequest rulesApplierRequest;
    rulesApplierRequest.Message = MakeRulesApplierMessage(request.message);
    rulesApplierRequest.Recipients = MakeRulesApplierRecipientMap(request.recipients);
    return rulesApplierRequest;
}

}
