#pragma once

#include <mail/notsolitesrv/src/errors.h>
#include <mail/notsolitesrv/src/msearch/types/request.h>
#include <mail/notsolitesrv/src/msearch/types/response.h>

#include <boost/asio/io_context.hpp>

#include <functional>
#include <optional>
#include <memory>

namespace NNotSoLiteSrv::NMSearch {

using TSubscriptionStatusResult = std::optional<TSubscriptionStatusResponse>;
using TSubscriptionStatusCallback = std::function<void(TErrorCode, TSubscriptionStatusResult)>;

class IMSearchClient {
public:
    virtual ~IMSearchClient() = default;

    virtual void SubscriptionStatus(boost::asio::io_context& ioContext, const TSubscriptionStatusRequest& request,
        TSubscriptionStatusCallback callback) const = 0;
};

using TMSearchClientPtr = std::shared_ptr<IMSearchClient>;

} // namespace NNotSoLiteSrv::NMSearch
