#pragma once

#include "client.h"

#include <mail/notsolitesrv/src/context.h>
#include <mail/notsolitesrv/src/errors.h>
#include <mail/notsolitesrv/src/http/types.h>
#include <mail/notsolitesrv/src/types/common.h>
#include <mail/notsolitesrv/src/msearch/types/request.h>

#include <string>
#include <memory>

namespace NNotSoLiteSrv::NMSearch {

class TMSearchClientImpl
    : public std::enable_shared_from_this<TMSearchClientImpl>
    , public IMSearchClient {
public:
    TMSearchClientImpl(TContextPtr ctx, TClusterCallPtr clusterCall, TTvmModulePtr tvmModule);

    void SubscriptionStatus(boost::asio::io_context& ioContext, const TSubscriptionStatusRequest& request,
        TSubscriptionStatusCallback callback) const override;

private:
    THttpRequest MakeSubscriptionStatusHttpRequest(const TSubscriptionStatusRequest& request) const;
    std::string GetTvmServiceTicket() const;
    void ProcessSubscriptionStatusResponse(TErrorCode ec, THttpResponse response,
        TSubscriptionStatusCallback callback) const;
    void ProcessError(TErrorCode ec, THttpResponse response, TSubscriptionStatusCallback callback) const;
    std::string MakeErrorStatusMessage(std::string responseBody) const;
    TSubscriptionStatusResult ParseSubscriptionStatusResponse(const std::string& responseBody) const;

    TContextPtr Ctx;
    TClusterCallPtr ClusterCall;
    TTvmModulePtr TvmModule;
};

using TMSearchClient = TMSearchClientImpl;

} // namespace NNotSoLiteSrv::NMSearch
