#pragma once

#include <mail/notsolitesrv/src/context.h>
#include <mail/notsolitesrv/src/errors.h>
#include <mail/notsolitesrv/src/msettings/types/request.h>
#include <mail/notsolitesrv/src/msettings/types/response.h>

#include <functional>
#include <optional>
#include <memory>

namespace NNotSoLiteSrv::NMSettings {

using TParamsResult = std::optional<TParamsResponse>;
using TParamsCallback = std::function<void(TErrorCode, TParamsResult)>;

class IMSettingsClient {
public:
    virtual ~IMSettingsClient() = default;

    virtual void GetParams(TContextPtr ctx, const TParamsRequest& request, TParamsCallback callback) const = 0;
    virtual void GetProfile(TContextPtr ctx, const TParamsRequest& request, TParamsCallback callback) const = 0;
};

using TMSettingsClientPtr = std::shared_ptr<IMSettingsClient>;

} // namespace NNotSoLiteSrv::NMSettings
