#pragma once

#include "client.h"

#include <mail/notsolitesrv/src/config.h>
#include <mail/notsolitesrv/src/errors.h>
#include <mail/notsolitesrv/src/http/types.h>
#include <mail/notsolitesrv/src/types/common.h>
#include <mail/notsolitesrv/src/msettings/types/request.h>

#include <boost/asio/io_context.hpp>

#include <string>
#include <memory>
#include <utility>

namespace NNotSoLiteSrv::NMSettings {

class TMSettingsClientImpl
    : public std::enable_shared_from_this<TMSettingsClientImpl>
    , public IMSettingsClient {
public:
    TMSettingsClientImpl(boost::asio::io_context& io, TConfigPtr config, TClusterCallPtr clusterCall,
        TTvmModulePtr tvmModule);

    void GetParams(TContextPtr ctx, const TParamsRequest& request, TParamsCallback callback) const override;
    void GetProfile(TContextPtr ctx, const TParamsRequest& request, TParamsCallback callback) const override;

private:
    void Get(TContextPtr ctx, const TParamsRequest& request, TParamsCallback callback, const std::string& handle) const;
    std::pair<EError, THttpRequest> MakeGetParamsHttpRequest(TContextPtr ctx, const TParamsRequest& request,
        const std::string& handle) const;
    std::pair<EError, std::string> GetTvmServiceTicket(TContextPtr ctx) const;
    void ProcessGetParamsResponse(TContextPtr ctx, TErrorCode ec, THttpResponse response, TParamsCallback callback) const;
    void ProcessError(TContextPtr ctx, TErrorCode ec, THttpResponse response, TParamsCallback callback) const;
    TParamsResult ParseGetParamsResponse(TContextPtr ctx, const std::string& responseBody) const;

    boost::asio::io_context& Io;
    TConfigPtr Config;
    TClusterCallPtr ClusterCall;
    TTvmModulePtr TvmModule;
};

using TMSettingsClient = TMSettingsClientImpl;

} // namespace NNotSoLiteSrv::NMSettings
