#include "mthr.h"

#include <mail/notsolitesrv/src/mthr/util.h>
#include <mail/notsolitesrv/src/tskv/log.h>

namespace NNotSoLiteSrv::NMthr {

static const std::string MTHR{"MTHR"};

TMthr::TMthr(TConfigPtr config)
    : Rules{InitializeMergeRules(*config->Mthr)}
{
}

TMthrResult TMthr::GetThreadInfo(TContextPtr context, TMthrRequest mthrRequest) const {
    try {
        const auto response{MakeMthrResponse(CalcDefaultThreadInfo(BuildMessageInfo(mthrRequest), Rules))};
        NSLS_LOG_NOTICE(context, log::message = "thread_info result",
            log::merge_policy = response.ThreadInfo.Rule, log::where_name = MTHR);
        return response;
    }  catch (const std::exception& ex) {
        NSLS_LOG_ERROR(context, log::message = "failed to get thread info", log::exception = ex,
            log::where_name = MTHR);
    } catch (...) {
        NSLS_LOG_ERROR(context, log::message = "failed to get thread info", log::where_name = MTHR);
    }

    return {};
}

}
