#pragma once

#include <mail/notsolitesrv/lib/mthr/src/mail_threads.h>
#include <mail/notsolitesrv/lib/mthr/src/merge_rules.h>
#include <mail/notsolitesrv/lib/mthr/src/message_info.h>
#include <mail/notsolitesrv/src/config/mthr.h>
#include <mail/notsolitesrv/src/mthr/types/request.h>
#include <mail/notsolitesrv/src/mthr/types/response.h>

#include <string>
#include <vector>

namespace NNotSoLiteSrv::NMthr {

::NMthr::TMergeRules InitializeMergeRules(const NConfig::TMthr& config);
void SetReferences(::NMthr::TMessageInfo& messageInfo, const std::vector<std::string>& references);
::NMthr::TMessageInfo BuildMessageInfo(const TMthrRequest& request);
::NMthr::TMailThreadInfo CalcDefaultThreadInfo(const ::NMthr::TMessageInfo& messageInfo,
    const ::NMthr::TMergeRules& mergeRules);
TThreadInfo MakeThreadInfo(const ::NMthr::TMailThreadInfo& mailThreadInfo);
TMthrResponse MakeMthrResponse(const ::NMthr::TMailThreadInfo& mailThreadInfo);

}
