#pragma once

#include "client.h"
#include <mail/notsolitesrv/src/context.h>
#include <mail/notsolitesrv/src/errors.h>
#include <yplatform/zerocopy/segment.h>
#include <map>

namespace NNotSoLiteSrv::NMulcagate::NMulti {

struct TRequest {
    std::string Uid;
    bool Spam = false;
    yplatform::zerocopy::segment Data;
};

struct TResult {
    TErrorCode ErrorCode = {};
    std::string Stid;
};

using TRequests = std::map<std::string, TRequest>; // mds id -> TRequest
using TResults = std::map<std::string, TResult>;   // uid -> TResult
using TCallback = std::function<void(TErrorCode, const TResults&)>;

void Put(TContextPtr ctx, const TRequests& request, TClientPtr client, TCallback callback);

} // namespace NNotSoLiteSrv::NMulcagate::NMulti
