#pragma once

#include "data_provider.h"
#include <mail/notsolitesrv/src/msettings/client.h>
#include <yplatform/coroutine.h>
#include <util/string/cast.h>

namespace NNotSoLiteSrv::NNewEmails {

class TAutoRepliesDataProvider: public TDataProvider {
public:
    class TSettingsGetter {
    public:
        using TYieldCtx = yplatform::yield_context<TSettingsGetter>;
        using TCallback = std::function<void(TErrorCode, std::string)>;

        TSettingsGetter(TContextPtr ctx, const std::string& uid, NMSettings::TMSettingsClientPtr mSettingsClient, TCallback cb)
            : Ctx(ctx)
            , Uid(uid)
            , MSettingsClient(mSettingsClient)
            , Callback(std::move(cb))
        {}

        void operator()(
            TYieldCtx yctx,
            TErrorCode ec = TErrorCode(),
            const NMSettings::TParamsResult& result = {}) const;

        NMSettings::TParamsRequest MakeRequest() const {
            return {
                .Uid = FromString<TUid>(Uid),
                .Params = { "from_name" }
            };
        }

    private:
        TContextPtr Ctx;
        const std::string Uid;
        NMSettings::TMSettingsClientPtr MSettingsClient;
        TCallback Callback;
    };

public:
    TAutoRepliesDataProvider(
        TContextPtr ctx,
        const TEmail& email,
        const NUser::TUser& user,
        TMessagePtr msg,
        boost::asio::io_context& ioContext,
        NMSettings::TMSettingsClientPtr mSettingsClient);

    bool IsAcceptedMessage() const override;
    void AsyncLoadExternalData(TCallback callback) override;

    const NConfig::TSmtpClient& GetConfig() const override;
    std::string GetSenderName() const override;
    TEmail GetMailFrom() const override;
    std::vector<TRecipient> GetRecipients() const override;
    std::string GetMessage() const override;
    TDeliveryFlags GetDeliveryFlags() const override;

    std::string GetFromDisplayName() const;
    std::string MakeReSubject() const;

private:
    boost::asio::io_context& IoContext;
    NMSettings::TMSettingsClientPtr MSettingsClient;
    std::optional<std::string> DisplayName;
};

TDataProviderPtr CreateAutoRepliesDataProvider(
    TContextPtr ctx,
    const TEmail& email,
    const NUser::TUser& user,
    TMessagePtr message,
    boost::asio::io_context& ioContext,
    NMSettings::TMSettingsClientPtr mSettingsClient);

} // namespace NNotSoLiteSrv::NNewEmails
