#include "data_provider.h"

#include <mail/notsolitesrv/src/tskv/logger.h>

namespace NNotSoLiteSrv::NNewEmails {

TDataProvider::TDataProvider(
    TContextPtr ctx,
    const TEmail& email,
    const NUser::TUser& user,
    TMessagePtr msg,
    const std::string& wherePrefix
)
    : Ctx(ctx)
    , Email(email)
    , User(user)
    , Message(msg)
    , Where(wherePrefix)
{}

void TDataProvider::AsyncLoadExternalData(TCallback callback) {
    return callback(EError::Ok);
}

bool TDataProvider::IsAcceptedMessageCheck() const {
    auto hint = Message->GetXYHintByUid(User.Uid);
    if (!hint.forward) {
        return false;
    }

    // MPROTO-1713: Disable forwards for users with karma >= 85 if they were
    // created after 01.01.2015. For the others karma threshold is set to 100.
    if ((User.Karma >= 100 || (User.Karma >= 85 && User.RegistrationDate >= 1420070400))) {
        NSLS_LOG_CTX_NOTICE(
            logdog::message="ommiting forward/notify/autoreply from " + Email + "; reason: bad karma",
            logdog::where_name=Where);
        // FIXME: for java-tests compatibility
        for (const auto& rcpt: GetRecipients()) {
            NSLS_LOG_CTX_NOTICE(
                logdog::message="ommiting forward/notify/autoreply to " + rcpt.Email + "; reason: bad karma",
                logdog::where_name=Where);
        }
        return false;
    }

    if (Message->IsDSN() && User.IsPDDMaillist) {
        NSLS_LOG_CTX_NOTICE(
            logdog::message=
                "omitting forward/notify/autoreply from " + Email +
                ": cannot forward from PDD maillist mailbox!",
            logdog::where_name=Where);
        return false;
    }

    return true;
}

bool TDataProvider::IsAcceptedMessage() const {
    bool accepted = IsAcceptedMessageCheck();
    if (!accepted) {
        NSLS_LOG_CTX_NOTICE(
            logdog::message=GetSenderName() + " action skipped; for "+ Email,
            logdog::where_name=Where);
    }

    return accepted;
}

bool TDataProvider::ForceLocal() const {
    return false;
}

bool TDataProvider::NeedPermanentStid() const {
    return false;
}

const std::string& TDataProvider::GetWherePrefix() const {
    return Where;
}

} // NNotSoLiteSrv::NNewEmails
