#pragma once

#include <mail/notsolitesrv/src/context.h>
#include <mail/notsolitesrv/src/config/smtpclient.h>
#include <mail/notsolitesrv/src/message/message.h>
#include <mail/notsolitesrv/src/user/user.h>

namespace NNotSoLiteSrv::NNewEmails {

using TEmail = std::string;

struct TNotifyMode {
    bool Success = false;
    bool Delay = false;
    bool Failure = false;
};

struct TRecipient {
    TEmail Email;
    TNotifyMode NotifyMode;
    std::string Uid;
};
using TRecipients = std::vector<TRecipient>;

struct TDeliveryFlags {
    bool CheckSpam = false;
    bool CheckVirus = false;
    bool SignDkim = false;
};

class TDataProvider {
public:
    using TCallback = std::function<void(TErrorCode)>;

    TDataProvider(
        TContextPtr ctx,
        const TEmail& email,
        const NUser::TUser& user,
        TMessagePtr msg,
        const std::string& wherePrefix);
    virtual ~TDataProvider() = default;

    virtual bool IsAcceptedMessage() const;
    virtual void AsyncLoadExternalData(TCallback callback);

    virtual const NConfig::TSmtpClient& GetConfig() const = 0;

    const std::string& GetWherePrefix() const;
    virtual std::string GetSenderName() const = 0;
    virtual TEmail GetMailFrom() const = 0;
    virtual TRecipients GetRecipients() const = 0;
    virtual std::string GetMessage() const = 0;
    virtual TDeliveryFlags GetDeliveryFlags() const = 0;
    virtual bool ForceLocal() const;
    virtual bool NeedPermanentStid() const;

protected:
    bool IsAcceptedMessageCheck() const;

protected:
    TContextPtr Ctx;
    const TEmail Email;
    const NUser::TUser User;
    TMessagePtr Message;
    std::string Where;
};

using TDataProviderPtr = std::unique_ptr<TDataProvider>;

} // namespace NNotSoLiteSrv::NNewEmails
