#include "domain_rule_forwards.h"

#include <mail/notsolitesrv/src/tskv/log.h>

#include <algorithm>
#include <iterator>
#include <memory>
#include <utility>

namespace NNotSoLiteSrv::NNewEmails {

TDomainRuleForwardsDataProvider::TDomainRuleForwardsDataProvider(TContextPtr ctx, const TEmail& email,
    const NUser::TUser& user, TMessagePtr message)
    : TDataProvider(ctx, email, user, message, "DRFWD")
{
}

const NConfig::TSmtpClient& TDomainRuleForwardsDataProvider::GetConfig() const {
    return *Ctx->GetConfig()->DomainForward;
}

bool TDomainRuleForwardsDataProvider::IsAcceptedMessage() const {
    return (!User.DeliveryResult.DomainRuleForwards.empty());
}

std::string TDomainRuleForwardsDataProvider::GetSenderName() const {
    return "domain_rule_forward";
}

TEmail TDomainRuleForwardsDataProvider::GetMailFrom() const {
    return Ctx->GetConfig()->DomainForward->MailFrom;
}

std::vector<TRecipient> TDomainRuleForwardsDataProvider::GetRecipients() const {
    std::vector<TRecipient> recipients;
    auto transformer{[](const auto& email){return TRecipient{email, {}, {}};}};
    std::transform(User.DeliveryResult.DomainRuleForwards.begin(),
        User.DeliveryResult.DomainRuleForwards.end(), std::back_inserter(recipients), std::move(transformer));
    return recipients;
}

std::string TDomainRuleForwardsDataProvider::GetMessage() const {
    auto data{Message->Compose()};
    return {data.begin(), data.end()};
}

TDeliveryFlags TDomainRuleForwardsDataProvider::GetDeliveryFlags() const {
    return {};
}

TDataProviderPtr CreateDomainRuleForwardsDataProvider(TContextPtr ctx, const TEmail& email,
    const NUser::TUser& user, TMessagePtr message)
{
    return std::make_unique<TDomainRuleForwardsDataProvider>(std::move(ctx), email, user, std::move(message));
}

}
