#pragma once

#include "data_provider.h"

#include <mail/notsolitesrv/src/config/smtpclient.h>
#include <mail/notsolitesrv/src/context.h>
#include <mail/notsolitesrv/src/message/message.h>
#include <mail/notsolitesrv/src/user/user.h>

#include <string>
#include <vector>

namespace NNotSoLiteSrv::NNewEmails {

class TDomainRuleForwardsDataProvider: public TDataProvider {
public:
    TDomainRuleForwardsDataProvider(TContextPtr ctx, const TEmail& email, const NUser::TUser& user,
        TMessagePtr message);

    bool IsAcceptedMessage() const override;
    const NConfig::TSmtpClient& GetConfig() const override;
    std::string GetSenderName() const override;
    TEmail GetMailFrom() const override;
    std::vector<TRecipient> GetRecipients() const override;
    std::string GetMessage() const override;
    TDeliveryFlags GetDeliveryFlags() const override;
};

TDataProviderPtr CreateDomainRuleForwardsDataProvider(TContextPtr ctx, const TEmail& email,
    const NUser::TUser& user, TMessagePtr message);

}
