#include "forwards.h"

#include <mail/notsolitesrv/src/tskv/logger.h>

namespace NNotSoLiteSrv::NNewEmails {

TForwardsDataProvider::TForwardsDataProvider(
    TContextPtr ctx,
    const TEmail& email,
    const NUser::TUser& user,
    TMessagePtr message
)
    : TDataProvider(ctx, email, user, message, "FWD")
{
}

const NConfig::TSmtpClient& TForwardsDataProvider::GetConfig() const {
    return *Ctx->GetConfig()->Forward;
}

bool TForwardsDataProvider::IsAcceptedMessage() const {
    if (!TDataProvider::IsAcceptedMessage()) {
        return false;
    }
    if (User.DeliveryResult.Forwards.empty()) {
        return false;
    }
    if (Message->IsSpam(User.Uid)) {
        NSLS_LOG_CTX_NOTICE(
            logdog::message="forward action skipped; for " + Email + ": SPAM",
            logdog::where_name=Where);
        return false;
    }
    return true;
}

std::string TForwardsDataProvider::GetSenderName() const {
    return "forward";
}

TEmail TForwardsDataProvider::GetMailFrom() const {
    return Email;  // MAILDLV-3036. Use user's email as MAIL FROM to bypass SPF e.t.c
}

std::vector<TRecipient> TForwardsDataProvider::GetRecipients() const {
    std::vector<TRecipient> ret;
    std::transform(
        User.DeliveryResult.Forwards.begin(),
        User.DeliveryResult.Forwards.end(),
        std::back_inserter(ret),
        [](const std::string& email) -> TRecipient {
            return {email, {false, false, false}, {}};
        });
    return ret;
}

std::string TForwardsDataProvider::GetMessage() const {
    auto data = Message->Compose();
    return {data.begin(), data.end()};
}

TDeliveryFlags TForwardsDataProvider::GetDeliveryFlags() const {
    return {false, false, false};
}

TDataProviderPtr CreateForwardsDataProvider(
    TContextPtr ctx,
    const TEmail& email,
    const NUser::TUser& user,
    TMessagePtr msg)
{
    return TDataProviderPtr{new TForwardsDataProvider(ctx, email, user, msg)};
}

} // namespace NNotSoLiteSrv::NNewEmails
