#pragma once

#include "data_provider.h"

namespace NNotSoLiteSrv::NNewEmails {

class TForwardsDataProvider: public TDataProvider {
public:
    TForwardsDataProvider(
        TContextPtr ctx,
        const TEmail& email,
        const NUser::TUser& user,
        TMessagePtr msg);

    bool IsAcceptedMessage() const override;

    const NConfig::TSmtpClient& GetConfig() const override;
    std::string GetSenderName() const override;
    TEmail GetMailFrom() const override;
    std::vector<TRecipient> GetRecipients() const override;
    std::string GetMessage() const override;
    TDeliveryFlags GetDeliveryFlags() const override;
};

TDataProviderPtr CreateForwardsDataProvider(
    TContextPtr ctx,
    const TEmail& email,
    const NUser::TUser& user,
    TMessagePtr message);

} // namespace NNotSoLiteSrv::NNewEmails
