#pragma once

#include "data_provider.h"

namespace NNotSoLiteSrv::NNewEmails {

class TNotifiesDataProvider: public TDataProvider {
public:
    TNotifiesDataProvider(
        TContextPtr ctx,
        const TEmail& email,
        const NUser::TUser& user,
        TMessagePtr msg);

    bool IsAcceptedMessage() const override;

    const NConfig::TSmtpClient& GetConfig() const override;
    std::string GetSenderName() const override;
    TEmail GetMailFrom() const override;
    std::vector<TRecipient> GetRecipients() const override;
    std::string GetMessage() const override;
    TDeliveryFlags GetDeliveryFlags() const override;

private:
    std::string GetUnreadUrl() const;
};

TDataProviderPtr CreateNotifiesDataProvider(
    TContextPtr ctx,
    const TEmail& email,
    const NUser::TUser& user,
    TMessagePtr message);

} // namespace NNotSoLiteSrv::NNewEmails
