#pragma once

#include "data_provider.h"
#include <mail/notsolitesrv/src/msettings/client.h>
#include <yplatform/coroutine.h>

namespace NNotSoLiteSrv::NNewEmails {

class TProcessor : public std::enable_shared_from_this<TProcessor> {
public:
    using TCallback = std::function<void(TErrorCode)>;
    using TSenderCallback = std::function<void(TErrorCode)>;
    using TAsyncSender = std::function<void(TContextPtr, const TDataProvider&, TSenderCallback)>;
    using TYieldCtx = yplatform::yield_context<TProcessor>;

    TProcessor(TContextPtr ctx, TAsyncSender sender, TDataProviderPtr provider);

    void Process(TCallback callback);

    void operator()(TYieldCtx yctx, TErrorCode errc = {});

private:
    TContextPtr Ctx;
    TAsyncSender AsyncSend;
    TDataProviderPtr Provider;

    TCallback Callback;
    std::string Where;
};

using TProcessorPtr = std::unique_ptr<TProcessor>;
using TProcessors = std::vector<TProcessorPtr>;

TProcessors CreateSuitableProcessors(
    TContextPtr ctx,
    TProcessor::TAsyncSender sender,
    const NUser::TStorage& userStorage,
    TMessagePtr message,
    const TEmail& from,
    boost::asio::io_context& ioContext,
    NMSettings::TMSettingsClientPtr mSettingsClient);

} // namespace NNotSoLiteSrv::NNewEmails
