#include "related_uids.h"
#include <mail/notsolitesrv/src/blackbox/client.h>
#include <mail/notsolitesrv/src/config/related_uids.h>
#include <mail/notsolitesrv/src/reflection/xyandexhint.h>
#include <util/generic/is_in.h>

namespace NNotSoLiteSrv::NNewEmails {

TRelatedUidsDataProvider::TRelatedUidsDataProvider(
    TContextPtr ctx,
    const TEmail& email,
    const NUser::TUser& user,
    TMessagePtr message,
    const TEmail& mailFrom
)
    : TDataProvider(ctx, email, user, message, "MAJOR")
    , MailFrom(mailFrom)
{
    for (const auto& uid: Ctx->GetConfig()->RelatedUids->GetRelatedUids(user.Uid)) {
        RelatedUsers.emplace_back(NUser::TUser{.Uid=uid});
    }
}

const NConfig::TSmtpClient& TRelatedUidsDataProvider::GetConfig() const {
    return *Ctx->GetConfig()->RelatedUids;
}

bool TRelatedUidsDataProvider::IsAcceptedMessage() const {
    if (RelatedUsers.empty()) {
        return false;
    }

    if (User.DeliveryResult.FolderType == "draft" &&
            IsIn(User.DeliveryResult.LabelSymbols, "draft_label"))
    {
        return true;
    }

    return false;
}

void TRelatedUidsDataProvider::AsyncLoadExternalData(TCallback callback) {
    NBlackbox::GetUsers(Ctx, NBlackbox::TUsers(RelatedUsers.begin(), RelatedUsers.end()), std::move(callback));
}

std::string TRelatedUidsDataProvider::GetSenderName() const {
    return "major";
}

TEmail TRelatedUidsDataProvider::GetMailFrom() const {
    return MailFrom;
}

std::vector<TRecipient> TRelatedUidsDataProvider::GetRecipients() const {
    std::vector<TRecipient> ret;
    for (const auto& user: RelatedUsers) {
        if (user.Status != NUser::ELoadStatus::Found) {
            continue;
        }
        if (user.DeliveryResult.ErrorCode) {
            continue;
        }
        ret.emplace_back(TRecipient{user.DefaultEmail, {false, false, false}, user.Uid});
    }
    return ret;
}

std::string TRelatedUidsDataProvider::MakeXYHint() {
    TXYandexHint hint;
    hint.filters = false;
    hint.notify = false;
    hint.forward = false;
    hint.folder_path = "\\Drafts";
    hint.label.emplace_back("symbol:draft_label");
    return "X-Yandex-Hint: " + NReflection::MakeXYHintHeaderValue(hint) + "\r\n";
}

std::string TRelatedUidsDataProvider::GetMessage() const {
    auto data = Message->Compose();
    std::string message;
    message.reserve(data.size() + 2048); // add some place for XYHint
    message.append(MakeXYHint());
    message.append(data.begin(), data.end());
    return message;
}

bool TRelatedUidsDataProvider::ForceLocal() const {
    return true;
}

TDeliveryFlags TRelatedUidsDataProvider::GetDeliveryFlags() const {
    return {false, false, false};
}

bool TRelatedUidsDataProvider::NeedPermanentStid() const {
    return true;
}

TDataProviderPtr CreateRelatedUidsDataProvider(
    TContextPtr ctx,
    const TEmail& email,
    const NUser::TUser& user,
    TMessagePtr msg,
    const TEmail& mailFrom)
{
    return TDataProviderPtr{new TRelatedUidsDataProvider(ctx, email, user, msg, mailFrom)};
}

} // namespace NNotSoLiteSrv::NNewEmails
