#pragma once

#include "data_provider.h"

namespace NNotSoLiteSrv::NNewEmails {

class TRelatedUidsDataProvider: public TDataProvider {
public:
    TRelatedUidsDataProvider(
        TContextPtr ctx,
        const TEmail& email,
        const NUser::TUser& user,
        TMessagePtr msg,
        const TEmail& mailFrom);

    bool IsAcceptedMessage() const override;
    void AsyncLoadExternalData(TCallback callback) override;

    const NConfig::TSmtpClient& GetConfig() const override;
    std::string GetSenderName() const override;
    TEmail GetMailFrom() const override;
    std::vector<TRecipient> GetRecipients() const override;
    std::string GetMessage() const override;
    TDeliveryFlags GetDeliveryFlags() const override;
    bool ForceLocal() const override;
    bool NeedPermanentStid() const override;

private:
    static std::string MakeXYHint();

private:
    TEmail MailFrom;
    std::vector<NUser::TUser> RelatedUsers;
};

TDataProviderPtr CreateRelatedUidsDataProvider(
    TContextPtr ctx,
    const TEmail& email,
    const NUser::TUser& user,
    TMessagePtr message,
    const TEmail& mailFrom);

} // namespace NNotSoLiteSrv::NNewEmails
