#pragma once

#include <mail/notsolitesrv/src/errors.h>
#include <mail/notsolitesrv/src/furita/iclient.h>
#include <mail/notsolitesrv/src/message/message.h>
#include <mail/notsolitesrv/src/meta_save_op/types/request.h>
#include <mail/notsolitesrv/src/tupita/iclient.h>
#include <mail/yplatform/include/yplatform/coroutine.h>

#include <functional>
#include <memory>
#include <variant>

namespace NNotSoLiteSrv::NRules {

using TDomainRulesCallback = std::function<void(TErrorCode)>;

class IDomainRules {
public:
    virtual ~IDomainRules() = default;

    virtual void SetParams(TMessagePtr message, NMetaSaveOp::TRequest request,
        TDomainRulesCallback callback) = 0;

    using TYieldCtx = yplatform::yield_context<IDomainRules>;
    using TResult = std::variant<NFurita::TGetResult, NTupita::TCheckResult>;
    virtual void operator()(TYieldCtx yieldCtx, TErrorCode errorCode = {}, TResult result = {}) = 0;
};

using TDomainRulesPtr = std::shared_ptr<IDomainRules>;

}
