#pragma once

#include <mail/notsolitesrv/src/meta_save_op/types/request.h>
#include <mail/notsolitesrv/src/user/user.h>

namespace NNotSoLiteSrv::NRules {

bool DomainRulesInUse(const NMetaSaveOp::TRecipientMap& recipients);

inline auto MakeUserFilter() {
    return [](const auto& user) {
        return
            ((user.Status == NUser::ELoadStatus::Found) &&
             (!user.DeliveryResult.ErrorCode) &&
             user.DeliveryParams.NeedDelivery &&
             user.DeliveryParams.UseDomainRules &&
             user.DeliveryParams.DeliveryId.empty());
    };
}

}
