#pragma once

#include <mail/notsolitesrv/src/furita/types/response.h>
#include <mail/notsolitesrv/src/meta_save_op/types/request.h>
#include <mail/notsolitesrv/src/rules/domain/domain_rules.h>
#include <mail/notsolitesrv/src/rules/domain/types/furita.h>
#include <mail/notsolitesrv/src/rules/domain/types/tupita.h>
#include <mail/notsolitesrv/src/types/common.h>

#include <optional>
#include <set>
#include <string>
#include <vector>

namespace NNotSoLiteSrv::NRules {

std::set<TOrgId> MakeFuritaOrgIds(const NMetaSaveOp::TRecipientMap& recipients);
bool FuritaDomainRulesAvailable(const TFuritaClientResult& furitaClientResult);
TFuritaClientResult MakeEmptyFuritaClientResult();

bool MatchedDomainRulesCorrect(const std::vector<NFurita::TFuritaDomainRule>& rules,
    const TMatchedDomainRuleIndices& matchedRuleIndices);

bool DomainActionsCorrect(const std::vector<NFurita::TFuritaDomainAction>& actions);
bool DomainActionCorrect(const NFurita::TFuritaDomainAction& action);
bool DomainActionActionCorrect(const std::string& action);

bool DomainActionDataCorrect(const std::string& action,
    const std::optional<NFurita::TFuritaDomainActionData>& data);

TDomainRulesAccumulatedResult MakeDomainRulesAccumulatedResult(
    const std::vector<NFurita::TFuritaDomainRule>& rules,
    const TMatchedDomainRuleIndices& matchedRuleIndices);

void ApplyDomainAction(const NFurita::TFuritaDomainAction& action, TDomainRulesAccumulatedResult& result);

}
