#include "tupita.h"

#include <mail/notsolitesrv/src/meta_save_op/util/tupita.h>

#include <algorithm>
#include <cctype>
#include <iterator>
#include <string>
#include <utility>
#include <vector>

namespace NNotSoLiteSrv::NRules {

NTupita::TTupitaQuery MakeTupitaQuery(const std::string& queryId, const NFurita::TFuritaDomainRule& rule) {
    return {queryId, rule.ConditionQuery, rule.Terminal.value_or(false)};
}

std::vector<NTupita::TTupitaUser> MakeTupitaUsers(const NMetaSaveOp::TRequest& request, TUid uid,
    const std::vector<NFurita::TFuritaDomainRule>& rules)
{
    NTupita::TTupitaUser tupitaUser;
    tupitaUser.Uid = uid;
    for (auto ruleIndex{0ull}; ruleIndex < rules.size(); ++ruleIndex) {
        tupitaUser.Queries.emplace_back(MakeTupitaQuery(std::to_string(ruleIndex), rules[ruleIndex]));
    }

    tupitaUser.Spam = request.message.spam;
    return {std::move(tupitaUser)};
}

NTupita::TTupitaCheckRequest MakeTupitaCheckRequest(const NMetaSaveOp::TRequest& request, TUid uid,
    const std::vector<NFurita::TFuritaDomainRule>& rules)
{
    NTupita::TTupitaCheckRequest tupitaCheckRequest;
    tupitaCheckRequest.Message = NMetaSaveOp::MakeTupitaMessage(request, {});
    tupitaCheckRequest.Users = MakeTupitaUsers(request, uid, rules);
    return tupitaCheckRequest;
}

bool MatchedQueriesNumeric(const std::vector<std::string>& matchedQueries) {
    auto queryPredicate{[](const auto& query) {
        auto characterPredicate{[](auto character){return (std::isdigit(character) != 0);}};
        return (!query.empty() && std::all_of(query.cbegin(), query.cend(), std::move(characterPredicate)));
    }};

    return std::all_of(matchedQueries.cbegin(), matchedQueries.cend(), std::move(queryPredicate));
}

TMatchedDomainRuleIndices MakeMatchedDomainRuleIndices(const std::vector<std::string>& matchedQueries) {
    TMatchedDomainRuleIndices matchedRuleIndices;
    auto transformer{[](const auto& query){return std::stoull(query);}};
    std::transform(matchedQueries.cbegin(), matchedQueries.cend(), std::inserter(matchedRuleIndices,
        matchedRuleIndices.end()), std::move(transformer));
    return matchedRuleIndices;
}

bool MatchedDomainRuleIndicesCorrect(uint64_t ruleCount,
    const TMatchedDomainRuleIndices& matchedRuleIndices)
{
    auto predicate{[&](const auto& index){return (index < ruleCount);}};
    return std::all_of(matchedRuleIndices.cbegin(), matchedRuleIndices.cend(), std::move(predicate));
}

}
