#pragma once

#include <mail/notsolitesrv/src/furita/types/response.h>
#include <mail/notsolitesrv/src/meta_save_op/types/request.h>
#include <mail/notsolitesrv/src/rules/domain/types/tupita.h>
#include <mail/notsolitesrv/src/tupita/types/request.h>
#include <mail/notsolitesrv/src/types/common.h>

#include <cstdint>
#include <string>
#include <vector>

namespace NNotSoLiteSrv::NRules {

NTupita::TTupitaQuery MakeTupitaQuery(const std::string& queryId, const NFurita::TFuritaDomainRule& rule);

std::vector<NTupita::TTupitaUser> MakeTupitaUsers(const NMetaSaveOp::TRequest& request, TUid uid,
    const std::vector<NFurita::TFuritaDomainRule>& rules);

NTupita::TTupitaCheckRequest MakeTupitaCheckRequest(const NMetaSaveOp::TRequest& request, TUid uid,
    const std::vector<NFurita::TFuritaDomainRule>& rules);

bool MatchedQueriesNumeric(const std::vector<std::string>& matchedQueries);
TMatchedDomainRuleIndices MakeMatchedDomainRuleIndices(const std::vector<std::string>& matchedQueries);
bool MatchedDomainRuleIndicesCorrect(uint64_t ruleCount, const TMatchedDomainRuleIndices& matchedRuleIndices);

}
