#pragma once

#include <mail/notsolitesrv/src/furita/types/response.h>
#include <mail/notsolitesrv/src/meta_save_op/meta_save_op.h>
#include <mail/notsolitesrv/src/rules_applier/types/request.h>
#include <mail/notsolitesrv/src/rules_applier/types/response.h>
#include <mail/notsolitesrv/src/types/common.h>

#include <optional>
#include <string>
#include <unordered_map>
#include <unordered_set>
#include <vector>

namespace NNotSoLiteSrv::NRulesApplier {

using TMatchedRuleIds = std::unordered_set<std::string>;
using TMatchedRuleIdsByUid = std::unordered_map<TUid, TMatchedRuleIds>;
using TMatchedRules = std::vector<NFurita::TFuritaRule>;
using TMatchedRulesByUid = std::unordered_map<TUid, TMatchedRules>;

enum class EApplyResult {
    WithStore,
    WithoutStore
};

struct TApplyResult {
    void Accumulate(const TApplyResult& other);
    operator bool() const;

    bool appliedWithStore{false};
    bool appliedWithoutStore{false};
};

TRulesApplierResponse ApplyRules(
    TRulesApplierRequest request,
    const NMetaSaveOp::TFuritaClientResults& furitaClientResults,
    const NMetaSaveOp::TTupitaClientResults& tupitaClientResults);

bool FailedRecipient(TUid uid, const NMetaSaveOp::TFuritaClientResults& furitaClientResults,
    const NMetaSaveOp::TTupitaClientResults& tupitaClientResults);

TMatchedRuleIdsByUid MakeMatchedRuleIdsByUid(const NMetaSaveOp::TTupitaClientResults& tupitaClientResults);

TMatchedRulesByUid MakeMatchedRulesByUid(const NMetaSaveOp::TFuritaClientResults& furitaClientResults,
    TMatchedRuleIdsByUid matchedRuleIdsByUid);

TAppliedRules MakeAppliedRules(const TMessage& message, const TMatchedRules& matchedRules);

TApplyResult ApplyRule(const TMessage& message, const NFurita::TFuritaRule& rule,
    TAppliedRules& appliedRules);

std::optional<EApplyResult> ApplyAction(const TMessage& message, const NFurita::TFuritaAction& action,
    TAppliedRules& appliedRules);

TApplyResult ProcessApplyActionResult(const std::optional<EApplyResult>& applyResult);
std::string MakeAutoreplyAddress(const TMessage& message);

}
