#pragma once

#include <mail/notsolitesrv/src/types/common.h>
#include <mail/notsolitesrv/src/types/email_address.h>

#include <map>
#include <optional>

namespace NNotSoLiteSrv::NRulesApplier {

struct TMessage {
    std::optional<TEmailAddress> From;
    std::optional<std::string> Sender;
    std::optional<std::string> ReplyTo;
};

struct TRecipient {
    TUid Uid;
    bool UseFilters{true};
};

using TRecipientMap = std::map<TDeliveryId, TRecipient>;
struct TRulesApplierRequest {
    TMessage Message;
    TRecipientMap Recipients;
};

}
