#pragma once

#include <mail/notsolitesrv/src/types/common.h>

#include <map>
#include <string>
#include <vector>

namespace NNotSoLiteSrv::NRulesApplier {

struct TAutoreply {
    std::string Address;
    std::string Body;
};

struct TFolderCoords {
    std::string Fid;
    std::string Path;
};

struct TAppliedRules {
    std::vector<std::string> Notifies;
    std::vector<TAutoreply> Replies;
    std::vector<std::string> Forwards;
    TFolderCoords DestFolder;
    std::vector<std::string> Lids;
    std::vector<std::string> LabelSymbols;
    std::vector<std::string> RuleIds;
    bool StoreAsDeleted{false};
    std::string NoSuchFolderAction;
};

using TAppliedRulesMap = std::map<TDeliveryId, TAppliedRules>;
struct TRulesApplierResponse {
    TAppliedRulesMap AppliedRules;
    std::vector<TDeliveryId> FailedRecipients;
};

}
