#pragma once

#include "context.h"
#include "deliverer.h"
#include "envelope.h"
#include <mail/notsolitesrv/src/new_emails/processor.h>
#include <mail/notsolitesrv/src/tskv/userjournal_writer.h>
#include <mail/notsolitesrv/src/user/storage.h>
#include <yplatform/module.h>

namespace NNotSoLiteSrv {

class IServer: public yplatform::module {
public:
    virtual void init(const yplatform::ptree& cfg) = 0;
    virtual void reload(const yplatform::ptree& cfg) = 0;
    virtual TConfigPtr GetConfig() const = 0;
    virtual NTskv::TUserJournalPtr GetUserJournalWriter() const = 0;
    virtual void Deliver(
        TContextPtr ctx,
        std::shared_ptr<std::string> msg,
        const TEnvelope& envelope,
        NUser::TStoragePtr userStorage,
        const NTimeTraits::TSystemTimePoint& deliveryStartMark,
        NNewEmails::TProcessor::TAsyncSender newEmailsSender,
        TDeliverer::TCallback cb) = 0;

    virtual void Deliver(
        TContextPtr ctx,
        const std::string& stid,
        const TEnvelope& envelope,
        NUser::TStoragePtr userStorage,
        const NTimeTraits::TSystemTimePoint& deliveryStartMark,
        TDeliverer::TMessageProcessor syncMessageProcessor,
        NNewEmails::TProcessor::TAsyncSender newEmailsSender,
        TDeliverer::TCallback cb) = 0;
};

using TServerPtr = std::shared_ptr<IServer>;

} // namespace NNotSoLiteSrv
