#pragma once

#include <mail/notsolitesrv/src/config/smtpclient.h>
#include <mail/notsolitesrv/src/context.h>
#include <mail/notsolitesrv/src/errors.h>

#include <ymod_smtpclient/call.h>
#include <ymod_smtpclient/request.h>

#include <string>

namespace NNotSoLiteSrv::NSmtp {

using TRecipient = ymod_smtpclient::RcptTo;
using TRecipients = std::vector<TRecipient>;
using TMailFrom = ymod_smtpclient::MailFrom;
using TOnSmtpError = NConfig::TOnSmtpError;
using TCallback = std::function<void(TErrorCode, const std::string&)>;

void AsyncSendMessage(
    TContextPtr ctx,
    const NConfig::TSmtpClient& config,
    const TMailFrom& from,
    const TRecipients& recipients,
    const std::string& message,
    TCallback callback);

void AsyncSendMessageWithYmodSmtpClient(
    TContextPtr ctx,
    const NConfig::TSmtpClient& config,
    const TMailFrom& from,
    const TRecipients& recipients,
    const std::string& message,
    std::shared_ptr<ymod_smtpclient::Call> smtpClient,
    TCallback callback);

using TMessageSender = std::function<decltype(AsyncSendMessage)>;

} // namespace NNotSoLiteSrv::NSmtp
