#pragma once

#include "client.h"
#include <mail/notsolitesrv/src/context.h>
#include <mail/notsolitesrv/src/envelope.h>
#include <mail/notsolitesrv/src/message/message.h>
#include <mail/notsolitesrv/src/user/storage.h>

namespace NNotSoLiteSrv::NSmtp {

using TMetaCallback = std::function<void(TErrorCode, const std::string&)>;

void AsyncSendMeta(
    TContextPtr ctx,
    const TEnvelope& envelope,
    TMessagePtr message,
    const std::string& origEml,
    NUser::TStoragePtr userStorage,
    TMetaCallback callback);

void AsyncSendMetaWithSender(
    TContextPtr ctx,
    const TEnvelope& envelope,
    TMessagePtr message,
    const std::string& origEml,
    NUser::TStoragePtr userStorage,
    TMessageSender sender,
    TMetaCallback callback);

using TMetaSender = std::function<decltype(AsyncSendMeta)>;

} // namespace NNotSoLiteSrv::NSmtp
