#pragma once

#include "types/time.h"
#include <util/generic/noncopyable.h>

namespace NNotSoLiteSrv {

class TTimer: public TNonCopyable {
public:
    void Start() {
        StartMark = NTimeTraits::CurrentTick();
    }
    void Stop() {
        if (!Done) {
            Duration = NTimeTraits::CurrentTick() - StartMark;
        }
        Done = true;
    }
    bool Ready() const { return Done; }
    NTimeTraits::TDuration GetDuration() const { return Duration; }

private:
    bool Done = false;
    NTimeTraits::TDuration Duration = NTimeTraits::TMilliSeconds(0);
    NTimeTraits::TTimePoint StartMark = NTimeTraits::CurrentTick();
};

}
