#pragma once

#include <logdog/attributes/mail_attributes.h>
#include <logdog/backend/yplatform_log.h>
#include <logdog/format/tskv.h>

namespace log {

LOGDOG_DEFINE_ATTRIBUTE(std::string, org_id)
LOGDOG_DEFINE_ATTRIBUTE(std::string, uid)
LOGDOG_DEFINE_ATTRIBUTE(std::string, uniq_id)
LOGDOG_DEFINE_ATTRIBUTE(std::string, connection_id)
LOGDOG_DEFINE_ATTRIBUTE(std::string, envelope_id)
LOGDOG_DEFINE_ATTRIBUTE(std::string, merge_policy)
LOGDOG_DEFINE_ATTRIBUTE(std::string, response_body)
LOGDOG_DEFINE_ATTRIBUTE(std::string, domain_rule_ids)
LOGDOG_DEFINE_ATTRIBUTE(std::string, filter_ids)

using logdog::error_code;
using logdog::exception;
using logdog::message;
using logdog::where_name;

constexpr static auto NSLS_FORMATTER = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-notsolitesrv-tskv-log"));

} // namespace log

inline auto MakeNslsLogger() {
    return logdog::make_log(
        log::NSLS_FORMATTER, yplatform::log::source{ YGLOBAL_LOG_SERVICE, "notsolitesrv" });
}

#define NSLS_LOG_NOTICE(ctx, ...) LOGDOG_(ctx->GetLogger(), notice, __VA_ARGS__);
#define NSLS_LOG_DEBUG(ctx, ...) LOGDOG_(ctx->GetLogger(), debug, __VA_ARGS__);
#define NSLS_LOG_WARN(ctx, ...) LOGDOG_(ctx->GetLogger(), warning, __VA_ARGS__);
#define NSLS_LOG_ERROR(ctx, ...) LOGDOG_(ctx->GetLogger(), error, __VA_ARGS__);

#define NSLS_LOG_CTX_NOTICE(...) NSLS_LOG_NOTICE(Ctx, __VA_ARGS__)
#define NSLS_LOG_CTX_DEBUG(...) NSLS_LOG_DEBUG(Ctx, __VA_ARGS__)
#define NSLS_LOG_CTX_WARN(...) NSLS_LOG_WARN(Ctx, __VA_ARGS__)
#define NSLS_LOG_CTX_ERROR(...) NSLS_LOG_ERROR(Ctx, __VA_ARGS__)
