#include "userjournal_writer.h"
#include <mail/notsolitesrv/src/config/user_journal.h>
#include <mail/library/utf8/utf8.h>

#include <user_journal/service_factory.h>
#include <yplatform/log.h>

#include <util/generic/strbuf.h>

namespace NNotSoLiteSrv::NTskv {

TUserJournalPtr CreateUserJournalWriter(TConfigPtr cfg) {
    user_journal::ServiceFactory factory;
    auto ujLogger = std::make_shared<yplatform::log::source>(YGLOBAL_LOG_SERVICE, "userjournal");
    factory.fileWriter([ujLogger](const std::string& line) {
            if (line.empty()) {
                return;
            }
            TStringBuf logLine(line);
            logLine.ChopSuffix("\n");
            YLOG(*ujLogger, info) << logLine;
        });
    factory.tskvFormat("mail-user-journal-tskv-log");
    factory.tableName(cfg->UserJournal->TableName);
    factory.locale(std::locale(NUtil::GetDefaultUtfLocale(), "C", std::locale::numeric));
    return factory.product();
}

} // nmespace NNotSoLiteSrv::NTskv
