#pragma once

#include "iclient.h"

#include <mail/notsolitesrv/src/context.h>
#include <mail/notsolitesrv/src/http/types.h>

namespace NNotSoLiteSrv::NTupita {

class TTupitaClient : public ITupitaClient {
public:
    TTupitaClient(TContextPtr ctx, TClusterCallPtr clusterCall);

    void Check(boost::asio::io_context& ioContext, TUid uid, std::string requestId,
        TTupitaCheckRequest checkRequest, TCheckCallback callback) const override;

private:
    THttpRequest MakeCheckRequest(TUid uid, std::string requestId,
        const TTupitaCheckRequest& checkRequest) const;
    void ProcessCheckResponse(TErrorCode errorCode, THttpResponse response, TCheckCallback callback) const;
    TCheckResult ParseCheckResponse(std::string responseBody) const;
    void ProcessError(TErrorCode errorCode, THttpResponse response, TCheckCallback callback) const;

    const TContextPtr Ctx;
    const TClusterCallPtr ClusterCall;
};

}
