#pragma once

#include <mail/notsolitesrv/src/errors.h>
#include <mail/notsolitesrv/src/tupita/types/request.h>
#include <mail/notsolitesrv/src/tupita/types/response.h>

#include <boost/asio.hpp>

#include <functional>
#include <memory>
#include <optional>
#include <string>

namespace NNotSoLiteSrv::NTupita {

using TCheckResult = std::optional<TTupitaCheckResponse>;
using TCheckCallback = std::function<void(TErrorCode, TCheckResult)>;

class ITupitaClient {
public:
    virtual ~ITupitaClient() = default;

    virtual void Check(boost::asio::io_context& ioContext, TUid uid, std::string requestId,
        TTupitaCheckRequest checkRequest, TCheckCallback callback) const = 0;
};

using TTupitaClientPtr = std::shared_ptr<ITupitaClient>;

}
