#pragma once

#include <mail/notsolitesrv/src/types/common.h>
#include <mail/notsolitesrv/src/types/email_address.h>

#include <map>
#include <optional>
#include <vector>

namespace NNotSoLiteSrv::NTupita {

struct TTupitaMessageLabelType {
    std::string Title;
};

struct TTupitaMessageLabel {
    std::string Name;
    bool IsSystem;
    bool IsUser;
    TTupitaMessageLabelType Type;
};

using TLabelsInfoMap = std::map<std::string, TTupitaMessageLabel>;
struct TTupitaMessage {
    std::string Subject;
    std::vector<TEmailAddress> From;
    std::vector<TEmailAddress> To;
    std::optional<std::vector<TEmailAddress>> Cc;
    std::string Stid;
    bool Spam;
    std::vector<uint32_t> Types;
    std::optional<uint64_t> AttachmentsCount;
    std::optional<TLabelsInfoMap> LabelsInfo;
    std::optional<std::string> Firstline;
};

struct TTupitaQuery {
    std::string Id;
    std::string Query;
    bool Stop;
};

struct TTupitaUser {
    TUid Uid;
    std::vector<TTupitaQuery> Queries;
    std::optional<bool> Spam;
};

struct TTupitaCheckRequest {
    TTupitaMessage Message;
    std::vector<TTupitaUser> Users;
};

}
