#pragma once

#include <yplatform/time_traits.h>
#include <iomanip>

namespace NNotSoLiteSrv {

namespace NTimeTraits {

using TSystemClock = std::chrono::system_clock;
using TSystemDuration = TSystemClock::duration;
using TSystemTimePoint = TSystemClock::time_point;

using TTimer = yplatform::time_traits::timer;
using TTimePoint = yplatform::time_traits::time_point;
using TDuration = yplatform::time_traits::duration;

using TSeconds = yplatform::time_traits::seconds;
using TMilliSeconds = yplatform::time_traits::milliseconds;
using TFloatSeconds = yplatform::time_traits::float_seconds;

using yplatform::time_traits::duration_cast;

inline auto Now() {
    return TSystemClock::now();
}

inline auto FromUnixTime(time_t unixTime) {
    return TSystemClock::from_time_t(unixTime);
}

inline auto CurrentTick() {
    return yplatform::time_traits::clock::now();
}

template <typename TDurationType>
inline auto ToString(const TDurationType& duration) {
    auto secs = duration_cast<TFloatSeconds>(duration);
    std::ostringstream os;
    os << std::fixed << std::setprecision(3) << secs.count();
    return os.str();
}

inline auto ToString(time_t t) {
    return yplatform::time_traits::to_simple_string(t);
}

}

} // namespace NNotSoLiteSrv
