#include "predicates.h"

namespace NNotSoLiteSrv::NUser {

bool Found(const TUser& user) {
    return user.Status == ELoadStatus::Found;
}

bool FromRcptTo(const TUser& user) {
    return user.DeliveryParams.IsFromRcptTo;
}

bool ForDelivery(const TUser& user) {
    return user.DeliveryParams.NeedDelivery && !user.DeliveryResult.ErrorCode;
}

bool WithDeliveryId(const TUser& user) {
    return !user.DeliveryParams.DeliveryId.empty();
}

TFilterPredicate ByUid(const std::string& uid) {
    return [uid](const TUser& user){ return user.Uid == uid; };
}

TFilterPredicate ByDeliveryId(const std::string& did) {
    return [did](const TUser& user){ return user.DeliveryParams.DeliveryId == did; };
}

} // namespace NNotSoLiteSrv::NUser
