#pragma once

#include "user.h"

namespace NNotSoLiteSrv::NUser {

using TFilterPredicate = std::function<bool(const TUser&)>;

constexpr bool All(const TUser&) { return true; }
bool Found(const TUser& user);
bool FromRcptTo(const TUser& user);
bool ForDelivery(const TUser& user);
bool WithDeliveryId(const TUser& user);

TFilterPredicate ByUid(const std::string& uid);
TFilterPredicate ByDeliveryId(const std::string& did);

} // namespace NNotSoLiteSrv::NUser
