#pragma once

#include <mail/notsolitesrv/src/blackbox/client.h>
#include <mail/notsolitesrv/src/blackwhitelist/client.h>
#include <mail/notsolitesrv/src/http/client.h>
#include <mail/notsolitesrv/src/user/user.h>
#include <mail/notsolitesrv/src/context.h>
#include <mail/notsolitesrv/src/errors.h>
#include <memory>

namespace NNotSoLiteSrv::NUser {

using TCallback = std::function<void(TErrorCode)>;

void ProcessUser(
    TContextPtr ctx,
    NBlackbox::TUserGetter resolver,
    NBlackWhiteList::TListsLoader loader,
    const std::string& email,
    bool isMailish,
    bool skipLists,
    TUser& userInfo,
    TCallback callback);

using TProcessor = std::function<decltype(ProcessUser)>;

} // namespace NNotSoLiteSrv::NUser
