#pragma once

#include <mail/notsolitesrv/src/errors.h>
#include <mail/notsolitesrv/src/types/common.h>

#include <map>
#include <optional>
#include <string>
#include <vector>

namespace NNotSoLiteSrv {
namespace NBlackWhiteList {

class TList;
using TListPtr = std::shared_ptr<TList>;

} // namespace NBlackWhiteList

namespace NUser {

struct TDeliveryResult {
    TErrorCode ErrorCode;
    bool MetaSend = false;
    std::string Mid;
    std::string ImapId;
    bool IsDuplicate = false;
    std::string Tid;
    std::string Fid;
    std::string FolderName;
    std::string FolderType;
    int FolderTypeCode = 0;
    std::vector<std::string> Lids;
    std::vector<std::string> LabelSymbols;
    std::vector<std::string> DomainRuleIds;
    std::vector<std::string> FilterIds;

    std::vector<std::string> DomainRuleForwards;
    std::vector<std::string> Forwards;
    std::vector<std::string> Notifies;
    std::vector<std::pair<std::string, std::string>> AutoReplies;
};

struct TDeliveryParams {
    bool IsFromRcptTo = true;
    bool NeedDelivery = true;
    bool CopyToInbox = false;
    bool UseDomainRules = false;
    TDeliveryId DeliveryId;
    NBlackWhiteList::TListPtr BWList;
};

enum class ELoadStatus {
    Unknown,
    Loaded,
    Found
};

struct TUser {
    ELoadStatus Status = ELoadStatus::Unknown;
    std::optional<TOrgId> OrgId;
    std::string Uid;
    std::string Suid;
    std::string Country;
    std::string DefaultEmail;
    std::string FIO;
    int Karma = 0;
    int KarmaStatus = 0;
    time_t RegistrationDate = 0;
    bool IsPDDMaillist = false;
    int LoginRule = 0;
    bool IsPhoneConfirmed = false;
    TDeliveryResult DeliveryResult;
    TDeliveryParams DeliveryParams;
};

} // namespace NUser
} // namespace NNotSoLiteSrv
