#include "file.h"

#include <exception>
#include <fstream>
#include <sstream>

namespace NNotSoLiteSrv::NUtil {

std::string ReadFile(const std::string& path) {
    std::ifstream file(path);
    if (!file) {
        throw std::runtime_error{"Failed to open file (\"" + path + "\")"};
    }

    std::stringstream string;
    string << file.rdbuf();
    if (!file || !string) {
        throw std::runtime_error{"Failed to read file (\"" + path + "\")"};
    }

    return string.str();
}

}
