#pragma once

#include <mail/notsolitesrv/src/envelope.h>
#include <string>

namespace NNotSoLiteSrv::NUtil {

enum class ECodec {
    Base64,
    QuotedPrintable
};

std::string DecodeHeaderRfc2047(const std::string& str, const std::string& fallbackEncoding = "");
std::string MakeRfc2822Date(time_t date);
std::string MakeXYForwardValue(const std::string& value);
std::string MakeMessageId();
bool ParseMessageId(const std::string& val, std::string& messageId);
std::pair<std::string, std::string> MakeReceivedHeader(
    const std::string& sessionId,
    const TEnvelope& envelope,
    const std::string& recipient);

std::string EncodeRfc2047(const std::string& str, ECodec codec = ECodec::Base64, const std::string& charset = "utf-8");

} // namespace NNotSoLiteSrv::NUtil
