#include "message.h"
#include "headers.h"
#include "string.h"
#include <mail/library/utf8/utf8.h>

#include <mimeparser/encoding.h>
#include <boost/algorithm/string/predicate.hpp>

namespace NNotSoLiteSrv::NUtil {

uint64_t CalculateAttachmentSize(const std::string& encoding, const TStringBuf& body) {
    uint64_t size = 0;

    if (boost::iequals(encoding, "base64")) {
        size = mulca_mime::base64_decoded_size(body.data(), body.size());
    } else if (boost::iequals(encoding, "quoted-printable")) {
        size = mulca_mime::qp_decoded_size(body.data(), body.size());
    }

    if (size == 0 || size > std::numeric_limits<int64_t>::max()) {
        size = body.Size();
    }

    return size;
}

std::string FilenameSanitized(const std::string& fname, size_t maxLength) {
    using namespace NUtil;
    std::string ret = StripBadChars(::NUtil::Utf8Sanitized(DecodeHeaderRfc2047(fname)));
    if (ret.size() <= maxLength) {
        return ret;
    }

    auto dotPos = ret.rfind(".");

    // Consider filename extension is from 3 to 5 characters long (including dot)
    if (dotPos == std::string::npos || ret.size() - dotPos > 5 || ret.size() - dotPos < 3) {
        ret = ::NUtil::Utf8ByteHead(ret, maxLength);
    } else {
        auto ext = ret.substr(dotPos);
        ret = ::NUtil::Utf8ByteHead(ret.substr(0, dotPos), maxLength - ext.size()) + ext;
    }

    return ret;
}

} // namespace NNotSoLiteSrv::NUtil
