#pragma once

#include <boost/optional.hpp>

#include <optional>

namespace NNotSoLiteSrv::NUtil {

template<typename Type> std::optional<Type> ConvertOptional(const boost::optional<Type>& value) {
    return value ? std::make_optional(*value) : std::nullopt;
}

template<typename Type> boost::optional<Type> ConvertOptional(const std::optional<Type>& value) {
    return value ? boost::make_optional(*value) : boost::none;
}

}
