#include "recognizer.h"

#include <util/system/yassert.h>

namespace NNotSoLiteSrv::NUtil {

namespace {

Recognizer::WrapperPtr instance;

} // namespace

const Recognizer::Wrapper& GetRecognizer() {
    Y_VERIFY(instance, "Please, use InitRecognizer() first!");
    return *instance;
}

void InitRecognizer(
    const std::string& languageDict,
    const std::string& languageWeights,
    const std::string& encodingDict)
{
    instance = Recognizer::create(languageDict.c_str(), languageWeights.c_str(), encodingDict.c_str());
}

} // namespace NNotSoLiteSrv::NUtil
