#pragma once

#include <string>

namespace NNotSoLiteSrv::NUtil {

struct TCaseInsensitiveCmp {
    bool operator()(const std::string& lhs, const std::string& rhs) const;
};

std::string DeBackslash(const std::string& val);
std::string StripBadChars(const std::string& val);
bool ExtractLogin(const std::string& email, std::string& login);
bool SplitEmail(const std::string& email, std::string& local, std::string& domain);

template <typename TType>
std::string ToString(TType val) {
    if constexpr (std::is_same_v<std::string, std::decay_t<TType>>) {
        return val;
    } else {
        return std::to_string(val);
    }
}

template <typename TIterator, typename TGetKey>
std::string JoinBy(TIterator begin, TIterator end, const std::string& sep, const TGetKey& getKey) {
    std::string ret;
    for (TIterator i = begin; i != end; ++i) {
        if (i != begin) {
            ret.append(sep);
        }

        ret.append(ToString(getKey(*i)));
    }
    return ret;
}

template <typename TContainer, typename TGetKey>
std::string JoinBy(const TContainer& cont, const std::string& sep, const TGetKey& getKey) {
    return JoinBy(std::begin(cont), std::end(cont), sep, getKey);
}

} // namespace NNotSoLiteSrv::NUtil
