#pragma once

#include <yplatform/zerocopy/segment.h>
#include <yplatform/zerocopy/streambuf.h>

namespace NNotSoLiteSrv::NUtil {

template <typename ...TArgs>
yplatform::zerocopy::segment MakeZerocopySegment(TArgs&&... args) {
    yplatform::zerocopy::streambuf buf;
    std::ostream os(&buf);
    (os << ... << args) << std::flush;
    return buf.detach(buf.end());
}

} // namespace NNotSoLiteSrv::NUtil
