LIBRARY(notsolitesrv)

OWNER(g:mproto)

NO_UTIL()

PEERDIR(
    library/cpp/digest/md5
    mail/butil
    mail/library/utf8
    mail/library/received_header
    mail/libyadns
    mail/logdog
    mail/mail_getter
    mail/message_types/lib
    mail/mimeparser
    mail/notsolitesrv/lib/firstline
    mail/notsolitesrv/lib/mthr/src
    mail/ymod_httpclient
    mail/ymod_mds
    mail/ymod_smtpclient
    mail/ymod_smtpserver/src
    mail/ymod_statserver
    mail/ymod_tvm
    mail/ymod_webserver
    mail/yplatform/lib
    mail/yreflection
    mail/user_journal
)

ADDINCL(
    GLOBAL mail/notsolitesrv/src
    contrib/libs/c-ares/include
)

SRCS(
    config.cpp
    constants.cpp
    context.cpp
    deliverer.cpp
    multiuser_processor.cpp
    GLOBAL server.cpp
    session.cpp
    timer.cpp

    config/firstline.cpp
    config/furita.cpp
    config/httpcall.cpp
    config/httpclient.cpp
    config/mdbsave.cpp
    config/message.cpp
    config/meta_save_op.cpp
    config/msearch.cpp
    config/msettings.cpp
    config/mthr.cpp
    config/recognizer.cpp
    config/related_uids.cpp
    config/session.cpp
    config/smtpclient.cpp
    config/smtpclient_domain_forward.cpp
    config/smtpclient_notify.cpp
    config/tupita.cpp
    config/user_journal.cpp

    blackbox/client.cpp
    blackbox/client_helpers.cpp

    blackwhitelist/client.cpp
    blackwhitelist/list.cpp

    firstline/firstline.cpp
    firstline/firstline_impl.cpp

    furita/client.cpp

    http/client.cpp
    http/handlers/handler.cpp
    http/handlers/impl/dryrun/dryrun.cpp
    http/handlers/impl/store/new_emails.cpp
    http/handlers/impl/store/store.cpp
    http/handlers/ping.cpp
    http/handlers/store.cpp
    http/util.cpp

    mdbsave/client.cpp

    message/message.cpp
    message/parser.cpp
    message/part.cpp
    message/processor.cpp
    message/types.cpp
    message/xyandexhint.cpp

    message/parser/header_data.cpp
    message/parser/header_handler_factory.cpp
    message/parser/message_handler.cpp
    message/parser/rfc2231.cpp

    meta_save_op/meta_save_op.cpp
    meta_save_op/types/request.cpp
    meta_save_op/types/response.cpp
    meta_save_op/util/common.cpp
    meta_save_op/util/firstline.cpp
    meta_save_op/util/furita.cpp
    meta_save_op/util/mdbsave.cpp
    meta_save_op/util/mthr.cpp
    meta_save_op/util/response.cpp
    meta_save_op/util/rules_applier.cpp
    meta_save_op/util/tupita.cpp

    msearch/client_impl.cpp

    msettings/client_impl.cpp

    mthr/mthr.cpp
    mthr/util.cpp

    mulcagate/client.cpp
    mulcagate/multiput.cpp

    new_emails/autoreplies.cpp
    new_emails/data_provider.cpp
    new_emails/domain_rule_forwards.cpp
    new_emails/forwards.cpp
    new_emails/notifies.cpp
    new_emails/processor.cpp
    new_emails/related_uids.cpp

    reflection/multimap.cpp
    reflection/xyandexhint.cpp

    rules/domain/domain_rules.cpp
    rules/domain/util/common.cpp
    rules/domain/util/furita.cpp
    rules/domain/util/tupita.cpp

    rules_applier/rules_applier.cpp

    smtp/client.cpp
    smtp/file_spool.cpp
    smtp/meta.cpp
    smtp/sender.cpp

    tskv/logger.cpp
    tskv/userjournal_writer.cpp

    tupita/client.cpp

    types/time.cpp

    user/predicates.cpp
    user/processor.cpp
    user/storage.cpp
    user/user.cpp

    util/file.cpp
    util/find_module.cpp
    util/headers.cpp
    util/log.cpp
    util/md5.cpp
    util/message.cpp
    util/message_id.rl6
    util/recognizer.cpp
    util/string.cpp
    util/zerocopy.cpp
)

END()
